using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Linq;
using System.Linq.Expressions;

namespace PI.ZB.N1200.ELearning.WinForms.Competence
{
    public partial class UCCompetenceList : PI.FM.N000.Base.WinForms.Controls.UCBOList<BL.BO.View.Competence, UCCompetenceDetails, BL.BO.Competence.Search>
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        public UCCompetenceList()
        {
            InitializeComponent();
        }

        protected virtual PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected override void InitAll()
        {
            base.InitAll();

            DataManager.SaveMode = Gemini.Core.WinForms.Controls.GDataManagerSaveMode.SelectedObject;
            DataManager.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.Save | Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh | Gemini.Core.WinForms.Controls.Type.ControlActionType.RefreshCurrent | Gemini.Core.WinForms.Controls.Type.ControlActionType.New | Gemini.Core.WinForms.Controls.Type.ControlActionType.Delete | Gemini.Core.WinForms.Controls.Type.ControlActionType.MoveDown | Gemini.Core.WinForms.Controls.Type.ControlActionType.MoveUp;

            if (Param.ShowMode == Gemini.Core.WinForms.Interface.ShowMode.IntegratedWindow)
            {
                DataManager.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh;
            }

            DataManager.InitColumns(new string[] { "Weight", "ID", "Name", "IsActive" });//Przetumaczone
            DataManager.ColumnCaptions = new string[] { Gemini.Dictionary.Text.Grid.LP.Value,Gemini.Dictionary.Text.Grid.ID.Value, Gemini.Dictionary.Text.Grid.Name.Value, Gemini.Dictionary.Text.Grid.Enabled.Value };
            DataManager.OnMove += new Gemini.Core.WinForms.Controls.GDataManagerMoveEventHandler<BL.BO.View.Competence>(OnMove);         
        }

        protected override void OnSave(Gemini.Core.WinForms.Controls.GDataManagerArgs<BL.BO.View.Competence> Args)
        {
            if (Args.Object != null)
            {
                DetailsView.Save();
                DataManager.RefreshCurrent();
            }
        }

        protected override BL.BO.View.Competence DoRestoreCurrent(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
        {
            return BLZSBELearning.Competence.View.Restore(BO);
        }

        protected override IList<BL.BO.View.Competence> OnLoadData(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            DataManager.TotalCount = BLZSBELearning.Competence.Count();

            return BLZSBELearning.Competence.View.Restore();
        }

        protected override BL.BO.View.Competence OnCreate(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            FNewCompetence _dialogNew = Gemini.Core.WinForms.Base.Form.Create<FNewCompetence>(Plugin, Environment);

            _dialogNew.Initialize(Plugin, Environment);
            
            if (_dialogNew.ShowDialog() == DialogResult.OK)
            {
                if (_dialogNew.NewCompetence != null)
                {
                    return BLZSBELearning.Competence.View.Restore(_dialogNew.NewCompetence);
                }
            }
            return null;
        }

        private void OnMove(Gemini.Core.WinForms.Controls.GDataManagerMoveArgs<BL.BO.View.Competence> Args)
        {

            if (DataManager.Current != null)
            {
                Args.Success = BLZSBELearning.Competence.Switch(Args.Object, Args.ObjectTo);

                foreach (BL.BO.View.Competence _loopCompetence in DataManager.GetObjectCollection())
                {
                    _loopCompetence.Weight = BLZSBELearning.Competence.View.Restore(_loopCompetence).Weight;
                } 
            }
        }

        protected override void OnRowClick()
        {
            Environment.WindowsHandler.Show(this.Plugin.Name, new Gemini.Core.WinForms.Base.AccessDescription(BL.Dictionary.Objects.UI.CompetenceEdit), new PI.FM.N000.Base.WinForms.Classes.Param(DataManager.Current));
        }

        public override void DialogResultOK()
        {
                Param.Object = DataManager.Current;
                Param.ObjectTitle = DataManager.Current.Name;
                Param.ObjectID = DataManager.Current.ID;
                Param.IsObjectValid = true ;
                Param.ClientID = BLZSBELearning.ClientID;
                Param.ObjectList = DataManager.GetSelectedObjects().Select(x => (FM.N000.Base.BL.BO.Base)x).ToList();
        }
    }
}
